<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/ProviderCategory.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init providerCategory object
$providerCategory = new ProviderCategory($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$providerCategory->pc_name = $data->pc_name;

if(check_auth()){
    // Create providerCategory
    if ($providerCategory->create()) {
        echo json_encode(
            array("message" => "Provider Category created")
        );
    } else {
        echo json_encode(
            array("message" => "Provider Category not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create provider category."
        )
    );
}