<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Profession.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$profession = new Profession($db);
$profession->profession_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$profession->read_single();

// profession array
$profession_arr = array(
    "profession_id" => $profession->profession_id,
    "prof_name" => $profession->prof_name
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($profession_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read profession."
        )
    );
}