<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Profession.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$profession = new Profession($db);

// Store read method result in variable & count rows
$result = $profession->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // User array
        $profession_arr = array();
        $profession_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $profession = array(
                'profession_id' => $profession_id,
                'prof_name' => $prof_name
            );

            // Push to "Data"
            array_push($profession_arr["data"], $profession);
        }
        // Convert result to JSON
        echo json_encode($profession_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No professions found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read professions."
        )
    );
}




