<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Profession.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init profession object
$profession = new Profession($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$profession->profession_id = $data->profession_id;

if(check_auth()){
    // Create a profession
    if ($profession->delete()) {
        echo json_encode(
            array("message" => "profession deleted")
        );
    } else {
        echo json_encode(
            array("message" => "profession not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete profession."
        )
    );
}