<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Presentation.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init presentation object
$presentation = new Presentation($db);
$presentation->presentation_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$presentation->read_single();


// presentation array
$presentation_arr = array(
    "presentation_id" => $presentation->presentation_id,
    "pres_file_path" => $presentation->pres_file_path,
    "company_id" => $presentation->company_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($presentation_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read presentation."
        )
    );
}