<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Presentation.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init presentation object
$presentation = new Presentation($db);

// Store read method result in variable & count rows
$result = $presentation->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // presentation array
        $presentation_arr = array();
        $presentation_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each presentation will look like this
            $presentation = array(
                'presentation_id' => $presentation_id,
                'pres_file_path' => $pres_file_path,
                'company_id' => $company_id
            );

            // Push to "Data"
            array_push($presentation_arr["data"], $presentation);
        }
        // Convert result to JSON
        echo json_encode($presentation_arr);
    } else {
        // No presentation returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No presentation found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read presentations."
        )
    );
}




