<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Phonebook.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init ab object
$phonebook = new Phonebook($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$phonebook->phonebook_id = $data->phonebook_id;
$phonebook->pb_name = $data->pb_name;
$phonebook->pb_number = $data->pb_number;
$phonebook->user_id = $data->user_id;

if(!check_auth()){
    // Create
    if ($phonebook->update()) {
        echo json_encode(
            array(
                "status" => 200,
                "message" => "Phonebook contact updated"
                )
        );
    } else {
        echo json_encode(
            array(
                "message" => "Phonebook contact not updated"
                )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update phonebook contact."
        )
    );
}