<?php 
// Allow requests from any origin
header("Access-Control-Allow-Origin: *");

// Allow specific methods
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

// Allow specific headers
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Set response content type
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Phonebook.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init phonebook object
$phonebook = new Phonebook($db);

$company_id =  isset($_GET["company_id"]) ? $_GET["company_id"] : die();
// Store read method result in variable & count rows
$result = $phonebook->read($company_id);
$num = $result->rowCount();

//if (isset($_SESSION["admin_token"])) {
    // -----------------------------------------------
if(!check_auth()){
    if ($num > 0) {
        // phonebook array
        $phonebook_arr = array();
        $phonebook_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each phonebook will look like this
            $phonebook = array(
                'phonebook_id' => $phonebook_id,
                'pb_name' => $pb_name,
                'pb_number' => $pb_number
            );

            // Push to "Data"
            array_push($phonebook_arr["data"], $phonebook);
        }
        // Convert result to JSON
        echo json_encode($phonebook_arr);
    } else {
        // No phonebook returned from query
        //header("HTTP/1.1 404");
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No phonebook contacts found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read phonebook contacts."
        )
    );
}

// --------------------------------------------------

// } else {
//     echo json_encode(
//         array(
//             "status" => 401,
//             "message" => "Not authorized to read phonebook contacts."
//         )
//     );
// }





