2<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Phonebook.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init object
$phonebook = new Phonebook($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$phonebook->phonebook_id = $data->phonebook_id;

if(!check_auth()){
    // Create
    if ($phonebook->delete()) {
        echo json_encode(
            array(
                "status" => 200,
                "message" => "Phonebook contact deleted"
                )
        );
    } else {
        echo json_encode(
            array(
                "message" => "Phonebook contact not deleted"
                )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete phonebook contact."
        )
    );
}