<?php 
/**
 * APPLICATION: NADZOR.app
 * AUTHOR: KOMOT DOO NIŠ */
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Message.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";
include_once "../../helpers/chat_name_helper.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init address book object
$message = new Message($db);

// GET compay_id from URL 
$id =  isset($_GET["id"]) ? $_GET["id"] : die();
// Store read method result in variable & count rows
$result = $message->read($id);
$num = $result->rowCount();

if(!check_auth()){
    if ($num > 0) {
        // address book array
        $message_arr = array();
        $message_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            $profile_name = getProfileNameByProfileId($conn, $message_sender);

            // Each address book will look like this
            $message = array(
                'id' => $message_id,
                'sender' => $profile_name,
                'time' => $message_time,
                'content' => $message_text,
                'room_id' => $room_id
            );
            
            // Push to "Data"
            array_push($message_arr["data"], $message);
        }
        // Convert result to JSON
        echo json_encode($message_arr);
    } else {
        // No address book returned from query
         header("HTTP/1.1 404");
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No messages found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read messages."
        )
    );
}




