<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/authorization.php";
include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Location.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init location object
$location = new Location($db);

// Store read method result in variable & count rows
$result = $location->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // location array
        $location_arr = array();
        $location_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each location will look like this
            $location = array(
                'location_id' => $location_id,
                'location_name' => $location_name,
                'company_id' => $company_id,
                'active' => $active
            );

            // Push to "Data"
            array_push($location_arr["data"], $location);
        }
        // Convert result to JSON
        echo json_encode($location_arr);
    } else {
        // No locations returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No locations found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read locations."
        )
    );
}




