<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/LocationEvent.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init locationEvent object
$locationEvent = new LocationEvent($db);

// Store read method result in variable & count rows
$result = $locationEvent->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // locationEvent array
        $locationEvent_arr = array();
        $locationEvent_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each locationEvent will look like this
            $locationEvent = array(
                'location_events_id' => $location_events_id,
                'title' => $title,
                'date' => $date,
                'created' => $created,   
                'modified' => $modified,
                'status' => $status,
                'location_id' => $location_id      
            );

            // Push to "Data"
            array_push($locationEvent_arr["data"], $locationEvent);
        }
        // Convert result to JSON
        echo json_encode($locationEvent_arr);
    } else {
        // No locationEvent returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No location activity found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read location events."
        )
    );
}




