<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/LocationEvent.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init locationEvent object
$locationEvent = new LocationEvent($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$locationEvent->location_events_id = $data->location_events_id;

if(check_auth()){
    // Create
    if ($locationEvent->delete()) {
        echo json_encode(
            array("message" => "location Event deleted")
        );
    } else {
        echo json_encode(
            array("message" => "location Event not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete location event."
        )
    );
}