<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Language.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$language = new Language($db);
$language->language_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$language->read_single();

// language array
$language_arr = array(
    "language_id" => $language->language_id,
    "lang_name" => $language->lang_name
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($language_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read language."
        )
    );
}