<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Language.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$language = new Language($db);

// Store read method result in variable & count rows
$result = $language->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // User array
        $language_arr = array();
        $language_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $language = array(
                'language_id' => $language_id,
                'lang_name' => $lang_name
            );

            // Push to "Data"
            array_push($language_arr["data"], $language);
        }
        // Convert result to JSON
        echo json_encode($language_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No languages found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read languages."
        )
    );
}





