<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Item.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init item object
$item = new Item($db);
$item->item_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$item->read_single();

// item array
$item_arr = array(
    "item_id" => $item->item_id,
    "item_title" => $item->item_title,
    "item_desc" => $item->item_desc,
    "item_mere" => $item->item_mere,
    "item_time" => $item->item_time,
    "item_visibility" => $item->item_visibility,
    "item_user" => $item->item_user,
    "item_image" => $item->item_image,
    "item_image1" => $item->item_image1,
    "item_image2" => $item ->item_image2,
    "item_image3" => $item->item_image3,
    "image_desc" => $item->image_desc,
    "image_desc1" => $item->image_desc1,
    "image_desc2" => $item->image_desc2,
    "image_desc3" => $item->image_desc3,
    "category_id" => $item->category_id,
    "report_id" => $item->report_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($item_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read item."
        )
    );
}