<?php 

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Item.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init item object
$item = new Item($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$item->item_title = $data->item_title;
$item->item_desc = $data->item_desc;
$item->item_mere = $data->item_mere;
$item->item_time = $data->item_time;
$item->item_visibility = $data->item_visibility;
$item->item_user = $data->item_user;
$item->item_image = $data->item_image;
$item->item_image1 = $data->item_image1;
$item->item_image2 = $data->item_image2;
$item->item_image3 = $data->item_image3;
$item->image_desc = $data->image_desc;
$item->image_desc1 = $data->image_desc1;
$item->image_desc2 = $data->image_desc2;
$item->image_desc3 = $data->image_desc3;
$item->category_id = $data->category_id;
$item->report_id = $data->report_id;

if(check_auth()){
    // Create item
    if ($item->create()) {
        echo json_encode(
            array("message" => "item created")
        );
    } else {
        echo json_encode(
            array("message" => "item not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create item."
        )
    );
}