<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Inbox.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init inbox object
$inbox = new Inbox($db);
$inbox->inbox_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$inbox->read_single();

// inbox array
$inbox_arr = array(
    "inbox_id" => $inbox->inbox_id,
    "company_id" => $inbox->company_id,
    "message1" => $inbox->message1,
    "created_at" => $inbox->created_at
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($inbox_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read inbox message."
        )
    );
}