<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Inbox.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init inbox object
$inbox = new Inbox($db);

// Store read method result in variable & count rows
$result = $inbox->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // inbox array
        $inbox_arr = array();
        $inbox_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each inbox will look like this
            $inbox = array(
                'inbox_id' => $inbox_id,
                'company_id' => $company_id,
                'message1' => $message1,
                'created_at' => $created_at       
            );

            // Push to "Data"
            array_push($inbox_arr["data"], $inbox);
        }
        // Convert result to JSON
        echo json_encode($inbox_arr);
    } else {
        // No inboxs returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No inbox messages found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read inbox messages."
        )
    );
}




