<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Header.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init header object
$header = new Header($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$header->head_id = $data->head_id;
$header->head_rep_title = $data->head_rep_title;
$header->head_comp_label = $data->head_comp_label;
$header->head_comp_title = $data->head_comp_title;
$header->head_proj_label = $data->head_proj_label;
$header->head_proj_title = $data->head_proj_title;
$header->head_loc_label = $data->head_loc_label;
$header->head_loc_title = $data->head_loc_title;
$header->head_logo = $data->head_logo;
$header->location_id = $data->location_id;

if(check_auth()){
    // Create header
    if ($header->update()) {
        echo json_encode(
            array("message" => "header updated")
        );
    } else {
        echo json_encode(
            array("message" => "header not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update header."
        )
    );
}