<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Header.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init header object
$header = new Header($db);

// Store read method result in variable & count rows
$result = $header->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // header array
        $header_arr = array();
        $header_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each header will look like this
            $header = array(
                'head_id' => $head_id,
                'head_rep_title' => $head_rep_title,
                'head_comp_label' => $head_comp_label,
                'head_comp_title' => $head_comp_title,
                'head_proj_label' => $head_proj_label,
                'head_proj_title' => $head_proj_title,  
                'head_loc_label' => $head_loc_label, 
                'head_loc_title' => $head_loc_title, 
                'head_logo' => $head_logo,
                'location_id' => $location_id   
            );

            // Push to "Data"
            array_push($header_arr["data"], $header);
        }
        // Convert result to JSON
        echo json_encode($header_arr);
    } else {
        // No headers returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No headers found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read headers."
        )
    );
}





