<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Gallery.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init gallery object
$gallery = new Gallery($db);
$gallery->gallery_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$gallery->read_single();

// gallery array
$gallery_arr = array(
    "gallery_id" => $gallery->gallery_id,
    "file_name" => $gallery->file_name,
    "company_id" => $gallery->company_id,
    "location_id" => $gallery->location_id,
    "user_id" => $gallery->user_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($gallery_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read gallery file."
        )
    );
}