<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Gallery.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init gallery object
$gallery = new Gallery($db);

// Store read method result in variable & count rows
$result = $gallery->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // gallery array
        $gallery_arr = array();
        $gallery_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each gallery will look like this
            $gallery = array(
                'gallery_id' => $gallery_id,
                'file_name' => $file_name,
                'company_id' => $company_id,
                'location_id' => $location_id,
                'user_id' => $user_id       
            );

            // Push to "Data"
            array_push($gallery_arr["data"], $gallery);
        }
        // Convert result to JSON
        echo json_encode($gallery_arr);
    } else {
        // No gallery returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No gallery found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read gallery files."
        )
    );
}




