<?php 

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Gallery.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init gallery object
$gallery = new Gallery($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$gallery->file_name = $data->file_name;
$gallery->company_id = $data->company_id;
$gallery->location_id = $data->location_id;
$gallery->user_id = $data->user_id;

if(check_auth()){
    // Create gallery
    if ($gallery->create()) {
        echo json_encode(
            array("message" => "gallery file created")
        );
    } else {
        echo json_encode(
            array("message" => "gallery file not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create gallery file."
        )
    );
}