<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/File.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init file object
$file = new File($db);
$file->file_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$file->read_single();

// file array
$file_arr = array(
    "file_id" => $file->file_id,
    "file_name" => $file->file_name,
    "company_id" => $file->company_id,
    "location_id" => $file->location_id,
    "user_id" => $file->user_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($file_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read file."
        )
    );
}