<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/File.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init file object
$file = new File($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$file->file_id = $data->file_id;

if(check_auth()){
    // Create a file
    if ($file->delete()) {
        echo json_encode(
            array("message" => "file deleted")
        );
    } else {
        echo json_encode(
            array("message" => "file not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete file."
        )
    );
}