<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/DriversLicence.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init driversLicence object
$driversLicence = new DriversLicence($db);
$driversLicence->drivers_licence_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$driversLicence->read_single();


// driversLicence array
$driversLicence_arr = array(
    "drivers_licence_id" => $driversLicence->drivers_licence_id,
    "dl_title" => $driversLicence->dl_title
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($driversLicence_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read drivers licence."
        )
    );
}
