<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/DriversLicence.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init driversLicence object
$driversLicence = new DriversLicence($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$driversLicence->dl_title = $data->dl_title;

if(check_auth()){
    // Create a driversLicence
    if ($driversLicence->create()) {
        echo json_encode(
            array("message" => "Drivers Licence created")
        );
    } else {
        echo json_encode(
            array("message" => "Drivers Licence not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create drivers licence."
        )
    );
}
