<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyRegion.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyRegion object
$companyRegion = new CompanyRegion($db);
$companyRegion->company_id = isset($_GET["company_id"]) ? $_GET["company_id"] : die();
$companyRegion->region_id = isset($_GET["region_id"]) ? $_GET["region_id"] : die();

$companyRegion->read_single($companyRegion->company_id, $companyRegion->region_id);

// companyRegion array
$companyRegion_arr = array(
    "company_id" => $companyRegion->company_id,
    "region_id" => $companyRegion->region_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($companyRegion_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company region."
        )
    );
}