<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyRegion.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyRegion object
$companyRegion = new CompanyRegion($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$companyRegion->company_id = $data->company_id;
$companyRegion->region_id = $data->region_id;

if(check_auth()){
    // Delete companyRegion
    if ($companyRegion->delete()) {
        echo json_encode(
            array("message" => "Company region deleted")
        );
    } else {
        echo json_encode(
            array("message" => "Company region not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete company region."
        )
    );
}