<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/CompanyPlace.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyPlace object
$companyPlace = new CompanyPlace($db);

$company_id = isset($_GET["company_id"]) ? $_GET["company_id"] : die();

// Store read method result in variable & count rows
$result = $companyPlace->read($company_id);
$num = $result->rowCount();

if(!check_auth()){
    if ($num > 0) {
        // companyPlace array
        $companyPlace_arr = array();
        $companyPlace_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each companyPlace will look like this
            $companyPlace = array(
                'company_place_id' => $company_place_id,
                'company_place_name' => $company_place_name,
                'company_place_address' => $company_place_address,
                'company_google_maps_link' => $company_google_maps_link,
                'company_place_city' => $company_place_city,
                'admin_id' => $admin_id,
                'company_id' => $company_id        
            );

            // Push to "Data"
            array_push($companyPlace_arr["data"], $companyPlace);
        }
        // Convert result to JSON
        echo json_encode($companyPlace_arr);
    } else {
        // No company places returned from query
        header("HTTP/1.1 404");
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No company places found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company places."
        )
    );
}




