<?php 
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, origin");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyPlace.php";

// Init DB connection
$database = new Database();
$db = $database->connect();
// Disable foreign key checks
$db->query("SET foreign_key_checks = 0");

// Init company note object
$companyPlace = new CompanyPlace($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$companyPlace->company_place_name = $data->company_place_name;
$companyPlace->company_place_address = $data->company_place_address;
$companyPlace->company_place_city = $data->company_place_city;
// $companyPlace->admin_id = $data->admin_id;
$companyPlace->company_id = $data->company_id;

if(!check_auth()){
    // Create company note
    if ($companyPlace->create() && $data->company_place_name != null && $data->company_place_address != null && $data->company_place_city != null) {
        echo json_encode(
            array("message" => "company place created")
        );
    } else {
        //header("HTTP/1.1 400");
        echo json_encode(
            array("message" => "company place not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create company place."
        )
    );
}