<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyEvent.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyEvent object
$companyEvent = new CompanyEvent($db);
$companyEvent->company_events_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$companyEvent->read_single();

// companyEvent array
$companyEvent_arr = array(
    "company_events_id" => $companyEvent->company_events_id,
    "title" => $companyEvent->title,
    "date" => $companyEvent->date,
    "created" => $companyEvent->created,
    "modified" => $companyEvent->modified,
    "status" => $companyEvent->status,
    "company_id" => $companyEvent->company_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($companyEvent_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company event."
        )
    );
}
