<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/CompanyEvent.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init Company object
$companyEvent = new CompanyEvent($db);
$result = $companyEvent->getLastEvent();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // companyEvent array
        $companyEvent_arr = array();
        $companyEvent_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each companyEvent will look like this
            $companyEvent = array(
                'company_events_id' => $company_events_id,
                'title' => $title,
                'date' => $date,
                'created' => $created,   
                'modified' => $modified,
                'status' => $status,
                'company_id' => $company_id      
            );

            // Push to "Data"
            array_push($companyEvent_arr["data"], $companyEvent);
        }
        // Convert result to JSON
        echo json_encode($companyEvent_arr);
    } else {
        // No companyEvent returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No company event found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read last company event."
        )
    );
}


?>
