<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyAdmin.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyAdmin object
$companyAdmin = new CompanyAdmin($db);

// Store read method result in variable & count rows
$result = $companyAdmin->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // companyAdmin array
        $companyAdmin_arr = array();
        $companyAdmin_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each companyAdmin will look like this
            $companyAdmin = array(
                'company_id' => $company_id,
                'admin_id' => $admin_id 
            );

            // Push to "Data"
            array_push($companyAdmin_arr["data"], $companyAdmin);
        }
        // Convert result to JSON
        echo json_encode($companyAdmin_arr);
    } else {
        // No companyAdmin returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No company admins found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company admins."
        )
    );
}






