<?php 

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyAdmin.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyAdmin object
$companyAdmin = new CompanyAdmin($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$companyAdmin->company_id = $data->company_id;
$companyAdmin->admin_id = $data->admin_id;

if(check_auth()){
    if ($companyAdmin->create()) {
        echo json_encode(
            array("message" => "company admin created")
        );
    } else {
        echo json_encode(
            array("message" => "company admin not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create company admin."
        )
    );
}
