<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyActivity.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyActivity object
$companyActivity = new CompanyActivity($db);
$companyActivity->company_id = isset($_GET["company_id"]) ? $_GET["company_id"] : die();
$companyActivity->act_id = isset($_GET["act_id"]) ? $_GET["act_id"] : die();

$companyActivity->read_single($companyActivity->company_id, $companyActivity->act_id);

// companyActivity array
$companyActivity_arr = array(
    "company_id" => $companyActivity->company_id,
    "act_id" => $companyActivity->act_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($companyActivity_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company activity."
        )
    );
}
