<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyActivity.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyActivity object
$companyActivity = new CompanyActivity($db);

// Store read method result in variable & count rows
$result = $companyActivity->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // companyActivity array
        $companyActivity_arr = array();
        $companyActivity_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each companyActivity will look like this
            $companyActivity = array(
                'company_id' => $company_id,
                'act_id' => $act_id 
            );

            // Push to "Data"
            array_push($companyActivity_arr["data"], $companyActivity);
        }
        // Convert result to JSON
        echo json_encode($companyActivity_arr);
    } else {
        // No companyActivity returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No company activities found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company activities."
        )
    );
}





