<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Company.php";

$database = new Database();
$db = $database->connect();

$company = new Company($db);
$company_id =  isset($_GET["company_id"]) ? $_GET["company_id"] : die();

$result = $company->readAccountById($company_id);
$num = $result->rowCount();

$companies_arr = array();

if(!check_auth()){
    if ($num > 0) {
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            $company_item = array(
                "company_id" => $company_id,
                "logo" => $company_logo,
                "company_name" => $company_name,
                "locations" => array(),
                "archived_locations" => array(),
                "users" => array(),
                "archived_users" => array(),
                "maxLocations" => 5,
                "maxUsers" => 10
            );

            // locations for the current company
            $company_item['locations'] = $company->getCompanyLocations($company_id);

            // users for the current company
            $company_item['users'] = $company->getActiveUsers($company_id);

            // archived users for the current company
            $company_item['archived_users'] = $company->getArchivedUsers($company_id);

            // archived locations for the current company
            $company_item['archived_locations'] = $company -> getArchivedLocations($company_id);


            $companies_arr[] = $company_item;
        }

        echo json_encode($companies_arr);
    } else {
        echo json_encode(array("message" => "No companies found"));
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read companies."
        )
    );
}

?>