<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Comment.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init comment object
$comment = new Comment($db);
$comment->comment_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$comment->read_single();

// comment array
$comment_arr = array(
    "comment_id" => $comment->comment_id,
    "comment_text" => $comment->comment_text,
    "comment_image" => $comment->comment_image,
    "comment_user" => $comment->comment_user,
    "comment_date" => $comment->comment_date,
    "comment_time" => $comment->comment_time,
    "item_id" => $comment->item_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($comment_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read comment."
        )
    );
}