<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Comment.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init comment object
$comment = new Comment($db);

// Store read method result in variable & count rows
$result = $comment->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // comment array
        $comment_arr = array();
        $comment_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each comment will look like this
            $comment = array(
                'comment_id' => $comment_id,
                'comment_text' => $comment_text,
                'comment_image' => $comment_image,
                'comment_user' => $comment_user,
                'comment_date' => $comment_date,
                'comment_time' => $comment_time,
                'item_id' => $item_id         
            );

            // Push to "Data"
            array_push($comment_arr["data"], $comment);
        }
        // Convert result to JSON
        echo json_encode($comment_arr);
    } else {
        // No comments returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No comments found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read comments."
        )
    );
}





