<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Comment.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init comment object
$comment = new Comment($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$comment->comment_id = $data->comment_id;

if(check_auth()){
    // Create a comment
    if ($comment->delete()) {
        echo json_encode(
            array("message" => "Comment deleted")
        );
    } else {
        echo json_encode(
            array("message" => "Comment not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete comment."
        )
    );
}