<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/City.php";


// Init DB connection
$database = new Database();
$db = $database->connect();

// Init city object
$city = new City($db);
$city->city_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$city->read_single();


// city array
$city_arr = array(
    "city_id" => $city->city_id,
    "city_name" => $city->city_name,
    "region_id" => $city->region_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($city_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read city."
        )
    );
}