<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/City.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";


// Init DB connection
$database = new Database();
$db = $database->connect();

// Init city object
$city = new City($db);

// Store read method result in variable & count rows
$result = $city->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // city array
        $city_arr = array();
        $city_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each city will look like this
            $city = array(
                'city_id' => $city_id,
                'city_name' => $city_name,
                'region_id' => $region_id
            );

            // Push to "Data"
            array_push($city_arr["data"], $city);
        }
        // Convert result to JSON
        echo json_encode($city_arr);
    } else {
        // No citys returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No citys found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read cities."
        )
    );
}




