<?php

session_start();

$_SESSION['user_id'] = 1;
$_SESSION['company_id'] = "";
$_SESSION['location_id'] = "";

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/ChatMessage.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init chatMessage object
$chatMessage = new ChatMessage($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

// Check authentication
if (!check_auth()) {
    // Get logged-in user data
    $loggedInUserId = $_SESSION['user_id'];
    $loggedInCompanyId = $_SESSION['company_id'];
    $loggedInLocationId = $_SESSION['location_id'];

    // Get the selected entity ID and type
    $selectedEntityId = isset($data->selectedEntityId) ? $data->selectedEntityId : null;
    $entityType = isset($data->entityType) ? $data->entityType : null;

    // Determine which table and field to use based on the entity type
    $entityTable = "";
    $entityField = "";

    if ($entityType === "company") {
        $entityTable = "companies";
        $entityField = "company_id";
    } elseif ($entityType === "location") {
        $entityTable = "locations";
        $entityField = "location_id";
    }

    // Store read method result in variable & count rows
    $messages = $chatMessage->readMessagesBetween($loggedInUserId, $selectedEntityId, $entityType);

    $num = count($messages);

    if ($num > 0) {
        // chatMessage array
        $chatMessage_arr = array();
        $chatMessage_arr["data"] = array();

        foreach ($messages as $row) {
            extract($row);

            // Each chatMessage will look like this
            $chatMessageItem = array(
                'chat_msg_id' => $chat_msg_id,
                'user_id' => $user_id,
                'content' => $content,
                'created_at' => $created_at,
                'location_id' => $location_id,
                'company_id' => $company_id       
            );

            // Get sender's name
            $senderName = $chatMessage->getSenderName($user_id, $company_id, $location_id);
            $chatMessageItem['sender_name'] = $senderName;

            // Push to "Data"
            array_push($chatMessage_arr["data"], $chatMessageItem);
        }
        // Convert result to JSON
        echo json_encode($chatMessage_arr);
    } else {
        // No chatMessages returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No chat messages found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read chat messages."
        )
    );
}
?>