<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Category.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init Category object
$category = new Category($db);

// Store read method result in variable & count rows
$result = $category->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // Category array
        $category_arr = array();
        $category_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each will look like this
            $category = array(
                'cat_id' => $cat_id,        
                'cat_name' => $cat_name    
                // 'cat_char' => $cat_char,        
                // 'cat_color' => $cat_color,        
                // 'location_id' => $location_id,        
            );

            // Push to "Data"
            array_push($category_arr["data"], $category);
        }
        // Convert result to JSON
        echo json_encode($category_arr);
    } else {
        // No categories returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No categories found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read categories."
        )
    );
}




