<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Area.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init Area object
$area = new Area($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$area->area_id = $data->area_id;
$area->area_title = $data->area_title;

if(check_auth()){
    // Create Area
    if ($area->update()) {
        echo json_encode(
            array("message" => "Area updated")
        );
    } else {
        echo json_encode(
            array("message" => "Area not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update area."
        )
    );
}