<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Area.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$area = new Area($db);
$area->area_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$area->read_single();

// Area array
$area_arr = array(
    "area_id" => $area->area_id,
    "area_title" => $area->area_title
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($area_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read area."
        )
    );
}