<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Area.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$area = new Area($db);

// Store read method result in variable & count rows
$result = $area->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // User array
        $area_arr = array();
        $area_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $area = array(
                'area_id' => $area_id,
                'area_title' => $area_title
            );

            // Push to "Data"
            array_push($area_arr["data"], $area);
        }
        // Convert result to JSON
        echo json_encode($area_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No areas found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read areas."
        )
    );
}




