<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Area.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init Area object
$area = new Area($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$area->area_id = $data->area_id;

if(check_auth()){
    // Create a Area
    if ($area->delete()) {
        echo json_encode(
            array("message" => "Area deleted")
        );
    } else {
        echo json_encode(
            array("message" => "Area not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete area."
        )
    );
}